package jamezo97.clonecraft.gui;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.CloneCraftUtils;
import jamezo97.clonecraft.Reflect;
import jamezo97.clonecraft.block.TileEntityGeneExtractor;
import jamezo97.clonecraft.dna.ItemData;
import jamezo97.clonecraft.item.ItemEntitySequencePaper;

import java.util.ArrayList;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;

import org.lwjgl.opengl.GL11;

public class GuiGeneExtractor extends GuiContainer{

	TileEntityGeneExtractor te;
	InventoryPlayer pInv;
	public GuiGeneExtractor(InventoryPlayer pInv,  TileEntityGeneExtractor te) {
		super(new ContainerGeneExtractor(pInv, te));
		this.xSize = 202;
		this.ySize = 198;
		this.te = te;
		this.pInv = pInv;
	}

	ResourceLocation bgImage = new ResourceLocation("CloneCraft:textures/gui/chromosomeExtractor.png");



	@Override
	protected void drawGuiContainerForegroundLayer(int par1, int par2) {

	}

	float percentDone;

	int minX = 0, minY = 0;

	@Override
	protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {

		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		this.mc.getTextureManager().bindTexture(bgImage);
		minX = (this.width - this.xSize) / 2;
		minY = (this.height - this.ySize) / 2;
		this.drawTexturedModalRect(minX, minY, 0, 0, this.xSize, this.ySize);
		int i1;
		if (this.te.isBurning())
		{
			i1 = this.te.getBurnTimeRemainingScaled(12);
			this.drawTexturedModalRect(minX + 149, minY + 52 + 12 - i1, 203, 13 - i1, 14, i1 + 2);
		}
		ItemStack dnaData = te.getStackInSlot(2);
		int len = 0;
		if(te.getStackInSlot(1) != null && dnaData != null && dnaData.itemID == CloneCraft.dnaData.itemID){
			ArrayList<Integer> genes = ((ItemEntitySequencePaper)dnaData.getItem()).entityIdToGene.get(dnaData.getItemDamage());
			if(genes != null){
				len = genes.size();
				if(len > 8){
					System.out.println("ENTITY HAS MORE THAN 8 GENES! Damn!");
				}
			}
		}
		int hide = 8 - len;
		GL11.glEnable(GL11.GL_BLEND);
		GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		GL11.glColor4f(1.0f, 1.0f, 1.0f, 0.95f);
		for(int a = 0; a < hide; a++){
			this.drawTexturedModalRect(minX+26 + (a * 18), minY+85, 154, 198, 18, 18);
		}

		GL11.glColor4f(1.0f, 1.0f, 1.0f, 0.95f);

		if(te.isBurning()){
			GL11.glColor4f(1.0f, 1.0f, 1.0f, te.GetIncubateTransition());
			this.drawModal(23, 42, 0, 246, 131, 4);
		}

		GL11.glDisable(GL11.GL_BLEND);
		
		GL11.glPushMatrix();
		
//		this.drawString(mc.fontRenderer, "Used", minX+178, minY+22, 0xffdddddd);
//		this.drawString(mc.fontRenderer, "Items", minX+178, minY+32, 0xffdddddd);
		
		GL11.glPopMatrix();

		//		percentDone += 0.0002f;



		if(te.extractTime > 0){
			percentDone = te.getPercentComplete();
			String message = null;
			if(percentDone < 0.05){
				//	 * 0.05 Collecting Bateria
				message = "Collecting Bateria";
			}else if(percentDone < 0.10){
				//	 * 0.10 Harvesting Plasmids
				message = "Harvesting Plasmids";
			}else if(percentDone < 0.15){
				//	 * 0.15 Splitting DNA Sample
				message = "Splitting DNA Sample";
			}else if(percentDone < 0.30){
				//	 * 0.30 Splicing DNA Samples Into Bacterial Plasmids
				message = "Splicing DNA Samples Into Plasmids";
			}else if(percentDone < 0.70){
				//	 * 0.70 Incubating Bacteria
				message = "Incubating Bacteria";
			}else if(percentDone < 0.80){
				//	 * 0.80 Decomposing Bacterial Walls
				message = "Decomposing Bacterial Walls";
			}else if(percentDone < 0.85){
				//	 * 0.85 Harvesting new Plasmids
				message = "Harvesting new Plasmids";
			}else if(percentDone < 0.90){
				//	 * 0.90 Collecting Duplicated DNA
				message = "Collecting Duplicated Genes";
			}else if(percentDone < 0.99){
				//	 * 0.99 Injecting Duplicated Genes Into Test Tubes
				message = "Injecting Duplicated Genes Into Test Tubes";
			}else if(percentDone <= 1.00){
				//	 * 1.00 Done
				message = "Done";
			}

			ItemStack dnaNeedle = te.getStackInSlot(1);
			
			float red = 0.0f, green = 0.0f, blue = 0.0f;
			if(dnaNeedle != null && dnaNeedle.itemID == CloneCraft.needle.itemID){
				int colour = CloneCraft.needle.getColorFromItemStack(dnaNeedle, 1);
				red = ((float)((colour >> 16) & 0xff)) / 255.0f;
				green = ((float)((colour >> 8) & 0xff)) / 255.0f;
				blue = ((float)((colour) & 0xff)) / 255.0f;
				GL11.glColor4f(red, green, blue, 1.0f);
			}



			float done;
			if(percentDone > 0.0){
				GL11.glColor4f(0.66f, 0.0f, 0.859f, 1.0f);
				if(percentDone > 0.0){
					done = getRenderChunkCompletion(percentDone, 0.0f, 0.043f);
					
					this.drawModal(37, 16, 0, 204, (int)(done*43), 2);
					
				}
				if(percentDone > 0.043f){
					done = getRenderChunkCompletion(percentDone, 0.043f, 0.058f);
					this.drawModal(78, 18, 41, 206, 2, (int)(done*15));
				}
				if(percentDone > 0.058f){
					done = getRenderChunkCompletion(percentDone, 0.058f, 0.095f);
					this.drawModal(80, 31, 43, 219, (int)(done*42), 2);
				}
				if(percentDone > 0.095){
					done = getRenderChunkCompletion(percentDone, 0.095f, 0.1f);
					int pix = (int)(done*5);
					this.drawModal(120, 31 - pix, 83, 219 - pix, 2, pix);
				}
				GL11.glColor4f(red, green, blue, 1.0f);
			}

			if(percentDone > 0.1){
				done = getRenderChunkCompletion(percentDone, 0.1f, 0.15f);
				this.drawModal(103, 16, 66, 204, (int)(done*9), 2);
			}
			if(percentDone > 0.30){
				if(percentDone > 0.30){
					done = getRenderChunkCompletion(percentDone, 0.3f, 0.3523f);
					this.drawModal(130, 16, 93, 204, (int)(done*26), 2);
				}
				if(percentDone > 0.3523f){
					done = getRenderChunkCompletion(percentDone, 0.3523f, 0.4065f);
					this.drawModal(154, 18, 137, 198, 2, (int)(done*27));
				}
				if(percentDone > 0.4065f){
					done = getRenderChunkCompletion(percentDone, 0.4065f, 0.6759f);
					int pix = (int)(done*134);
					this.drawModal(154-pix, 43, 136-pix, 201, pix, 2);
				}
				if(percentDone > 0.6759f){
					done = getRenderChunkCompletion(percentDone, 0.6759f, 0.7000f);
					this.drawModal(20, 45, 146, 198, 2, (int)(done*12));
				}
			}
			if(percentDone > 0.70){
				done = getRenderChunkCompletion(percentDone, 0.70f, 0.80f);
				this.drawModal(14, 57, 140, 210, 14, (int)(done*14));
			}
			if(percentDone > 0.75){
				done = getRenderChunkCompletion(percentDone, 0.75f, 0.85f);
				this.drawModal(28, 63, 0, 198, (int)(done*51), 2);
			}
			if(percentDone > 0.90){
				if(percentDone > 0.90f){
					done = getRenderChunkCompletion(percentDone, 0.90f, 0.9698f);
					this.drawModal(97, 63, 69, 198, (int)(done*45), 2);
				}
				if(percentDone > 0.9698f){
					done = getRenderChunkCompletion(percentDone, 0.9698f, 0.9900f);
					this.drawModal(140, 65, 125, 225, 2, (int)(done*13));
				}
			}
			if(percentDone > 0.99){
				done = getRenderChunkCompletion(percentDone, 0.99f, 1.0f);
				this.drawModal(15, 78, 0, 238, 146, (int)(done*7));
			}

			this.drawCenteredStringScaled(mc.fontRenderer, message, 88 + minX, 105+minY, 0xff003300 | ((int)((1-percentDone)*200) << 16) | ((int)(percentDone*200) << 8));
		}

//		System.out.println(String.format("%s, %s, %s, %s, %s, %s", mouseX, mouseY, minX, minY, xSize, ySize));
		
		{
			if((!te.isEmpty() || (mouseX >= minX && mouseY >= minY && mouseX <= minX+xSize && mouseY <= minY+ySize)) && te.extractTime == 0){

				String errorMessage = null;
				int errorColour = 0xcc3434;
				if(!te.isBurning() && !TileEntityFurnace.isItemFuel(te.getStackInSlot(3))){
					errorMessage = "Valid Fuel Source Is Missing";
					redSquareCoords.add(new int[]{148, 51, errorColour = 0xde25d0});
				}
				if(te.getStackInSlot(1) != null && te.getStackInSlot(2) != null){
					if(new ItemData(te.getStackInSlot(1)).currentEntity != te.getStackInSlot(2).getItemDamage()){
						errorMessage = "DNA Data and Sequence Data Must Match!";
						redSquareCoords.add(new int[]{86, 9, errorColour = 0xde2574});
						redSquareCoords.add(new int[]{113, 9, errorColour = 0xde2574});
					}
					if(new ItemData(te.getStackInSlot(1)).currentEntity == te.getStackInSlot(2).getItemDamage()){
						ArrayList<Integer> list = ItemEntitySequencePaper.entityIdToGene.get(te.getStackInSlot(2).getItemDamage());
						int size = list.size();
						ItemStack testTubes = te.getStackInSlot(5);
						int amount = 0;
						if(testTubes != null){
							amount = testTubes.stackSize;
						}
						if(amount < size){
							int missing = size-amount;
							redSquareCoords.add(new int[]{7, 86, errorColour = 0xde2525});
							errorMessage = (missing) + " Input Testube" + (missing>1?"s Are ":" Is ") +"Missing";
						}
						/*if(list != null){
							int missing = 0;
							for(int a = 13; a > 13 - list.size() && a > 5; a--){
								ItemStack testTube = te.getStackInSlot(a);
								if(!(testTube != null && testTube.itemID == CloneCraft.testTube.itemID && testTube.getItemDamage() == 0 && !new ItemData(testTube).isContaminated())){
									redSquareCoords.add(new int[]{26 + ((a-6)*18), 85, errorColour = 0xde2525});
									missing++;
									errorMessage = (missing) + " Output Testube" + (missing>1?"s Are ":" Is ") +"Missing";
								}
							}
						}*/
					}
				}else if(te.getStackInSlot(2) == null){
					errorMessage = "DNA Sequence Data Is Missing";
					redSquareCoords.add(new int[]{113, 9, errorColour = 0xa925de});
				}
				if(te.getStackInSlot(1) == null){
					errorMessage = "DNA Sample Is Missing";
					redSquareCoords.add(new int[]{86, 9, errorColour = 0xdea525});
				}
				
				//4068d0
				//af40de
				//cd5c8c
				//de2525
				//deb725
				
				//a925de
				//de25d0
				//de2574
				//de2525
				//de6225
				//dea525
				if(te.getStackInSlot(0) == null){
					redSquareCoords.add(new int[]{20, 9, errorColour = 0xde6225});
					errorMessage = "Contaminated Item Is Missing";
					//23c6c8
				}
				if(errorMessage != null){
					this.drawCenteredStringScaled(mc.fontRenderer, errorMessage, 88 + minX, 105+minY, errorColour | 0xff000000);
				}

				renderErrorSquares();
			}

		}
		CloneCraftUtils.renderSlotResourceOverlays(this);
		

	}
	
	int mouseX = 0, mouseY = 0;

	boolean first = true;
	@Override
	protected void mouseMovedOrUp(int par1, int par2, int par3) {
		super.mouseMovedOrUp(par1, par2, par3);
		if(first){
			first = false;
		}else{
			mouseX = par1;
			mouseY = par2;
		}
		
	}



	public void renderErrorSquares(){
		for(int a = 0; a < redSquareCoords.size(); a++){
			int[] xyc = redSquareCoords.get(a);
			this.drawRect(minX+xyc[0], minY+xyc[1], minX + xyc[0] + 16, minY + xyc[1] + 16, 0x66000000 | xyc[2]);//0x66dd2222);
		}
		redSquareCoords.clear();
	}
	ArrayList<int[]> redSquareCoords = new ArrayList<int[]>();

	public void drawCenteredStringScaled(FontRenderer par1FontRenderer, String par2Str, int par3, int par4, int par5){
		GL11.glPushMatrix();
		float scale = 0.75f;
		GL11.glTranslatef(par3*(1-scale), par4*(1-scale), 0.0f);
		GL11.glScalef(scale, scale, 0.0f);
		this.drawCenteredStringNoShad(par1FontRenderer, par2Str, par3, par4, par5);
		GL11.glPopMatrix();
		/*		this.drawRect(minX+85, minY+8, minX + 85+18, minY +8+18, 0x99dd2222);
		this.drawRect(minX+112, minY+8, minX + 112+18, minY +8+18, 0x99dd2222);*/
	}

	public void drawCenteredStringNoShad(FontRenderer par1FontRenderer, String par2Str, int par3, int par4, int par5)
	{
		par1FontRenderer.drawString(par2Str, par3 - par1FontRenderer.getStringWidth(par2Str) / 2, par4, par5);
	}

	public void drawModal(int x, int y, int u, int v, int width, int height){
		super.drawTexturedModalRect(x + minX, y + minY, u, v, width, height);
	}

	public float getRenderChunkCompletion(float percentDone, float min, float max){
		if(percentDone < max){
			return (percentDone - min) / (max-min);
		}
		return 1.0f;
	}

	/*
	 * Slot1: Contaminated Item
	 * Slot2: Entity DNA
	 * Slot3: Entity Sequence Data
	 * Slot4: Clean Test-Tube
	 * Slot5: Coal
	 * 
	 * Phrases:
	 * 0.05 Collecting Bateria
	 * 0.10 Harvesting Plasmids
	 * 0.15 Splitting DNA Sample
	 * 0.30 Splicing DNA Samples Into Bacterial Plasmids
	 * 0.70 Incubating Bacteria
	 * 0.80 Decomposing Bacterial Walls
	 * 0.85 Harvesting new Plasmids
	 * 0.90 Collecting Duplicated DNA
	 * 0.95 Injecting Duplicated Genes Into Test Tubes
	 * 1.00 Done
	 * */
	//Flint, Bucket, Needle, Redstone, Diamond, Furnace, IronBlock

}
